/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.api.capability.food;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.api.capability.food.CapabilityFood;
import net.dries007.tfc.api.capability.food.FoodData;
import net.dries007.tfc.api.capability.food.FoodHandler;
import net.dries007.tfc.api.capability.food.FoodTrait;
import net.dries007.tfc.api.capability.food.IFood;
import net.dries007.tfc.api.capability.heat.CapabilityItemHeat;
import net.dries007.tfc.api.capability.heat.ItemHeatHandler;
import net.dries007.tfc.util.agriculture.Food;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public class FoodHeatHandler
extends ItemHeatHandler
implements IFood,
ICapabilitySerializable<NBTTagCompound> {
    private final FoodHandler internalFoodCap;

    public FoodHeatHandler() {
        this(null, new FoodData(), 1.0f, 100.0f);
    }

    public FoodHeatHandler(@Nullable NBTTagCompound nbt, @Nonnull Food food) {
        this(nbt, food.getData(), food.getHeatCapacity(), food.getCookingTemp());
    }

    public FoodHeatHandler(@Nullable NBTTagCompound nbt, FoodData data, float heatCapacity, float meltTemp) {
        this.heatCapacity = heatCapacity;
        this.meltTemp = meltTemp;
        this.internalFoodCap = new FoodHandler(nbt, data);
        this.deserializeNBT(nbt);
    }

    @Override
    public long getCreationDate() {
        return this.internalFoodCap.getCreationDate();
    }

    @Override
    public void setCreationDate(long creationDate) {
        this.internalFoodCap.setCreationDate(creationDate);
    }

    @Override
    public long getRottenDate() {
        return this.internalFoodCap.getRottenDate();
    }

    @Override
    @Nonnull
    public FoodData getData() {
        return this.internalFoodCap.getData();
    }

    @Override
    public float getDecayDateModifier() {
        return this.internalFoodCap.getDecayDateModifier();
    }

    @Override
    public void setNonDecaying() {
        this.internalFoodCap.setNonDecaying();
    }

    @Override
    @Nonnull
    public List<FoodTrait> getTraits() {
        return this.internalFoodCap.getTraits();
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFood.CAPABILITY || capability == CapabilityItemHeat.ITEM_HEAT_CAPABILITY;
    }

    @Override
    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(this.hasCapability(capability, facing) ? this : null);
    }

    @Override
    @Nonnull
    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = super.serializeNBT();
        nbt.func_74782_a("food", (NBTBase)this.internalFoodCap.serializeNBT());
        return nbt;
    }

    @Override
    public void deserializeNBT(@Nullable NBTTagCompound nbt) {
        if (nbt != null) {
            this.internalFoodCap.deserializeNBT(nbt.func_74775_l("food"));
            super.deserializeNBT(nbt);
        }
    }
}

